﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Text;

namespace AZVIC.Ei8htPOS.Entities
{
    [Serializable()]
    public class HappyHours
    {
        public HappyHours()
        {

        }

        public HappyHours(IDataReader myDataRecord)
        {
            UniqueID = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("HappyHourPromoID")) ? Guid.Empty : myDataRecord.GetGuid(myDataRecord.GetOrdinal("HappyHourPromoID"));
            PromoName = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("PromoName")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("PromoName"));
            StartTime = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("StartTime")) ? DateTime.MinValue: myDataRecord.GetDateTime(myDataRecord.GetOrdinal("StartTime"));
            EndTime = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("EndTime")) ? DateTime.MinValue : myDataRecord.GetDateTime(myDataRecord.GetOrdinal("EndTime"));
            DisplayStartTime = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("DisplayStartTime")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("DisplayStartTime"));
            DisplayEndTime = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("DisplayEndTime")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("DisplayEndTime"));
            CreatedDate = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("CreatedDate")) ? DateTime.MinValue : myDataRecord.GetDateTime(myDataRecord.GetOrdinal("CreatedDate"));
            ModifiedDate = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ModifiedDate")) ? DateTime.MinValue : myDataRecord.GetDateTime(myDataRecord.GetOrdinal("ModifiedDate"));
            CreatedBy = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("CreatedBy")) ? Guid.Empty : myDataRecord.GetGuid(myDataRecord.GetOrdinal("CreatedBy"));
            ModifiedBy = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ModifiedBy")) ? Guid.Empty : myDataRecord.GetGuid(myDataRecord.GetOrdinal("ModifiedBy"));
            IsEnabled = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("IsEnabled")) ? false : myDataRecord.GetBoolean(myDataRecord.GetOrdinal("IsEnabled"));
        }

        public Guid UniqueID { get; set; }

        public string PromoName { get; set; }

        public DateTime StartTime { get; set; }

        public DateTime EndTime{ get; set; }

        public bool IsEnabled { get; set; }

        public string DisplayStartTime { get; set; }

        public string DisplayEndTime { get; set; }

        public DateTime CreatedDate { get; set; }

        public Guid CreatedBy { get; set; }

        public DateTime ModifiedDate { get; set; }

        public Guid ModifiedBy { get; set; }
    }
}
